﻿<%@ Page Language="c#" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Kasa" %>
<script runat="server">

    //Sortowyanie chronologiczne (standardowo wydruk jest sortowany zgodne z numerami dokumentów)
    static bool wydrukChronologiczny = false;
    
    class Element: IComparable {
           readonly string nazwa;
           decimal wpłaty;
           decimal wypłaty;
           public Element(Zaplata z) {
               this.nazwa = z.SposobZaplaty.Nazwa;
           }
           public void Add(Zaplata z) {
               wpłaty += z.Wpłata.Value;
               wypłaty += z.Wypłata.Value;
           }
           public int CompareTo(object v) {
               return string.Compare(Nazwa, ((Element)v).Nazwa, true);
           }
           public string Nazwa {
               get { return nazwa; }
           }
           public decimal Wpłata {
               get { return wpłaty; }
           }
           public decimal Wypłata {
               get { return wypłaty; }
           }
           public decimal Saldo {
               get { return wpłaty-wypłaty; }
           }
       }
    
       class Element2 {
           readonly string nazwa;
           object wpłaty;
           object wypłaty;
           static string marker = "--------------";
           public Element2(string nazwa, object wpłaty, object wypłaty) {
               this.nazwa = nazwa;
               this.wpłaty = wpłaty;
               this.wypłaty = wypłaty;
           }
           public string Nazwa {
               get { return nazwa; }
           }
           public object Wpłata {
               get { return wpłaty!=null ? wpłaty : marker; }
           }
           public object Wypłata {
               get { return wypłaty!=null ? wypłaty : marker; }
           }
       }
    
       Hashtable elements = new Hashtable();
       decimal sumWpł = 0;
       decimal sumWypł = 0;
    
    void Grid1_BeforeRow(Object sender, RowEventArgs args) {
           Zaplata z = (Zaplata)args.Row;
           if (z.NumeryDokumentow=="" || z.Opis.Contains(z.NumeryDokumentow))
               opis.EditValue = z.Opis;
           else
               opis.EditValue = z.Opis + "<br>Za: " + z.NumeryDokumentow;
    
           Element elem = (Element)elements[z.SposobZaplaty];
           if (elem==null) {
               elem = new Element(z);
               elements[z.SposobZaplaty] = elem;
           }
           elem.Add(z);
    
           sumWpł += z.Wpłata.Value;
           sumWypł += z.Wypłata.Value;
    }
    
    void Grid1_AfterRender(Object sender, EventArgs args) {
        RaportESP raport = (RaportESP)dc[typeof(RaportESP)];
           ArrayList arr = new ArrayList(elements.Values);
           arr.Sort();
           Grid2.DataSource = arr;
    
           Element2[] els = new Element2[3];
           els[0] = new Element2("Obroty", sumWpł, sumWypł);
           els[1] = new Element2("Stan poprzedni", GT(raport.SaldoPoczatkowe.Value), LT(raport.SaldoPoczatkowe.Value));
           els[2] = new Element2("Stan obecny", LT(raport.SaldoKoncowe.Value), GT(raport.SaldoKoncowe.Value));
    
           Grid3.DataSource = els;
       }
    
       object GT(decimal value) {
           if (value>0)
               return value;
           return null;
       }
    
       object LT(decimal value) {
           if (value<0)
               return -value;
           return null;
       }
    
    protected void dc_ContextLoad(object sender, EventArgs e) {
        RaportESP raport = (RaportESP)dc[typeof(RaportESP)];
        if (raport.Kasa.Typ != TypEwidencjiSP.Kasa) {
            numer.Visible = false;
            opis.ColSpan = 3;
            ReportHeader1.Title = "Wyciąg bankowy|</strong>Ewidencja:<strong> {0}</strong>, waluta:<strong> {1}|</strong>Numer:<strong> {2}|</strong>Okres:<strong> {3}";
        }

        if (wydrukChronologiczny) {
            Grid1.Sort = "DataDokumentu,NumerDokumentu";
            lp.DataMember = "#";
        }
    }

</script>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
    <title>Pełny raport kasowy</title> 
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <meta content="Microsoft Visual Studio 7.0" name="GENERATOR" />
    <meta content="C#" name="CODE_LANGUAGE" />
    <meta content="JavaScript" name="vs_defaultClientScript" />
    <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema" />
</head>
<body>
    <form id="PełnyRaportKasowy" method="post" runat="server">
        <ea:datacontext id="dc" runat="server" TypeName="Soneta.Kasa.RaportESP, Soneta.Kasa" OnContextLoad="dc_ContextLoad"></ea:datacontext>
        <cc1:ReportHeader id="ReportHeader1" title="Raport kasowy|</strong>Ewidencja:<strong> {0}</strong>, waluta:<strong> {1}|</strong>Numer:<strong> {2}|</strong>Okres:<strong> {3}" runat="server" DataMember3="Okres" DataMember2="Numer" DataMember1="Kasa.Waluta.Symbol" DataMember0="Kasa"></cc1:ReportHeader>

        <ea:grid id="Grid1" runat="server" RowsInRow="2" OnBeforeRow="Grid1_BeforeRow" RowTypeName="Soneta.Kasa.Zaplata" OnAfterRender="Grid1_AfterRender" DataMember="Zaplaty">
            <Columns>
                <ea:GridColumn EncodeHTML="true" Width="4" Align="Right" DataMember="Lp" Caption="LP." ID="lp" RowSpan="2"></ea:GridColumn>
                <ea:GridColumn EncodeHTML="true" Width="10" DataMember="DataDokumentu" Caption="Data" ID="data"></ea:GridColumn>
                <ea:GridColumn EncodeHTML="true" ColSpan="4" ID="opis"></ea:GridColumn>
                <ea:GridColumn EncodeHTML="true" Width="20" DataMember="NumerDokumentu" Caption="Numer" ID="numer" NoWrap="True"></ea:GridColumn>
                <ea:GridColumn EncodeHTML="true" DataMember="Podmiot" Caption="Podmiot" ID="podmiot"></ea:GridColumn>
                <ea:GridColumn EncodeHTML="true" Width="8" DataMember="SposobZaplaty" Total="Info" Caption="Forma" ID="płatność" NoWrap="True"></ea:GridColumn>
                <ea:GridColumn EncodeHTML="true" Width="12" Align="Right" DataMember="Wpłata.Value" Total="Sum" Caption="Wpłata" HideZero="True" Format="{0:n}" ID="Wpłata" RowSpan="2"></ea:GridColumn>
                <ea:GridColumn EncodeHTML="true" Width="12" Align="Right" DataMember="Wypłata.Value" Total="Sum" Caption="Wypłata" HideZero="True" Format="{0:n}" ID="wypłata" RowSpan="2"></ea:GridColumn>
            </Columns>
        </ea:grid>
		
		<ea:Section runat="server">
			<table id="Table3" cellspacing="5" width="100%">
				<tbody>
					<tr>
						<td valign="top">
							<ea:grid id="Grid2" WithSections="false" runat="server">
								<Columns>
									<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="LP."></ea:GridColumn>
									<ea:GridColumn Width="16" DataMember="Nazwa" Total="Info" Caption="Spos&#243;b zapłaty"></ea:GridColumn>
									<ea:GridColumn Width="14" Align="Right" DataMember="Wpłata" Total="Sum" Caption="Wpłata" Format="{0:n}"></ea:GridColumn>
									<ea:GridColumn Width="14" Align="Right" DataMember="Wypłata" Total="Sum" Caption="Wypłata" Format="{0:n}"></ea:GridColumn>
									<ea:GridColumn Width="14" Align="Right" DataMember="Saldo" Total="Sum" Caption="R&#243;żnica" Format="{0:n}"></ea:GridColumn>
								</Columns>
							</ea:grid>
						</td>
						<td valign="top" align="right">
							<ea:grid id="Grid3" WithSections="false" runat="server">
								<Columns>
									<ea:GridColumn Width="14" DataMember="Nazwa" Total="Info"></ea:GridColumn>
									<ea:GridColumn Width="14" Align="Right" DataMember="Wpłata" Total="Sum" Caption="Wpłata" Format="{0:n}"></ea:GridColumn>
									<ea:GridColumn Width="14" Align="Right" DataMember="Wypłata" Total="Sum" Caption="Wypłata" Format="{0:n}"></ea:GridColumn>
								</Columns>
							</ea:grid>
						</td>
					</tr>
				</tbody>
			</table>
		</ea:Section>
        
		<cc1:ReportFooter id="ReportFooter1" runat="server">
            <Subtitles>
                <cc1:FooterSubtitle SubtitleType="Operator"></cc1:FooterSubtitle>
                <cc1:FooterSubtitle Caption="Sporządził" SubtitleType="Podpis"></cc1:FooterSubtitle>
                <cc1:FooterSubtitle Caption="Sprawdził" SubtitleType="Podpis"></cc1:FooterSubtitle>
                <cc1:FooterSubtitle Caption="Zatwierdził" SubtitleType="Podpis"></cc1:FooterSubtitle>
            </Subtitles>
        </cc1:ReportFooter>
    </form>
</body>
</html>
